VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmPayroll 
   Caption         =   "PAYROLL FORM"
   ClientHeight    =   5850
   ClientLeft      =   120
   ClientTop       =   465
   ClientWidth     =   7920
   OleObjectBlob   =   "frmPayroll.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmPayroll"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Const EMP_SHEET = "EMPLOYEES"
Const ATT_SHEET = "ATTENDANCE"
Const PAY_SHEET = "PAYROLL"

Private Function NextPayrollID() As String
    Dim ws As Worksheet
    Dim r As Long
    
    Set ws = Sheets(PAY_SHEET)
    r = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
    
    If r < 2 Then
        NextPayrollID = "PAY001"
    Else
        NextPayrollID = "PAY" & Format(r, "000")
    End If
End Function



Private Sub CalIcon_Click()
Call Calendar.SelectedDate(Me.txtPaymentDate)
End Sub


Private Sub cmdGeneratePayroll_Click()

Const EMP_SHEET = "EMPLOYEES"
Const ATT_SHEET = "ATTENDANCE"
Const PAY_SHEET = "PAYROLL"

Dim empWS As Worksheet, attWS As Worksheet, payWS As Worksheet
Dim lastEmp As Long, lastAtt As Long, nextRow As Long
Dim i As Long, empID As String
Dim AbsentDays As Long
Dim Basic As Double, Allow As Double, Deduction As Double
Dim Gross As Double, AbsDed As Double, NetPay As Double
Dim PayrollMonth As Date
Dim r As Long

'====================================
' VALIDATE MONTH INPUT
'====================================
If txtMonth.Value = "" Then
    MsgBox "Enter a payroll month (example: Dec-2025 or 12/2025)", vbExclamation
    Exit Sub
End If

On Error Resume Next
PayrollMonth = CDate(txtMonth.Value)
If Err.Number <> 0 Then
    MsgBox "Invalid Month Format. Try: Dec-2025 or 12/2025", vbCritical
    Exit Sub
End If
On Error GoTo 0

Set empWS = Sheets(EMP_SHEET)
Set attWS = Sheets(ATT_SHEET)
Set payWS = Sheets(PAY_SHEET)

lastEmp = empWS.Cells(empWS.Rows.Count, "A").End(xlUp).Row
lastAtt = attWS.Cells(attWS.Rows.Count, "A").End(xlUp).Row

'====================================
' LOOP EMPLOYEES
'====================================
For i = 2 To lastEmp
    
    If LCase(empWS.Cells(i, 7).Value) = "active" Then
        
        empID = empWS.Cells(i, 1).Value
        
        Basic = Val(empWS.Cells(i, 8).Value)        'Basic Salary
        Allow = Val(empWS.Cells(i, 9).Value)        'Allowances
        Deduction = Val(empWS.Cells(i, 10).Value)   'Fixed Deductions (Column J)
        
        '------------------------------------
        ' COUNT ABSENCES IN SELECTED MONTH
        '------------------------------------
        AbsentDays = 0
        
        For r = 2 To lastAtt
            
            If Month(attWS.Cells(r, 1).Value) = Month(PayrollMonth) And _
               Year(attWS.Cells(r, 1).Value) = Year(PayrollMonth) And _
               attWS.Cells(r, 2).Value = empID Then
               
               If attWS.Cells(r, 3).Value = "A" Then
                    AbsentDays = AbsentDays + 1
               End If
               
            End If
        
        Next r
        
        '------------------------------------
        ' CALCULATIONS
        '------------------------------------
        Gross = Basic + Allow
        
        AbsDed = (Basic / 30) * AbsentDays   'Absence Deduction
        
        NetPay = Gross - AbsDed - Deduction  'Final Salary
        
        '------------------------------------
        ' WRITE TO PAYROLL SHEET
        '------------------------------------
        nextRow = payWS.Cells(payWS.Rows.Count, "A").End(xlUp).Row + 1
        
        payWS.Cells(nextRow, 1).Value = NextPayrollID
        payWS.Cells(nextRow, 2).Value = Format(PayrollMonth, "MMM-YYYY")
        payWS.Cells(nextRow, 3).Value = empID
        payWS.Cells(nextRow, 4).Value = Basic
        payWS.Cells(nextRow, 5).Value = Allow
        payWS.Cells(nextRow, 6).Value = AbsentDays
        payWS.Cells(nextRow, 7).Value = Deduction
        payWS.Cells(nextRow, 8).Value = Gross
        payWS.Cells(nextRow, 9).Value = AbsDed
        payWS.Cells(nextRow, 10).Value = NetPay
        payWS.Cells(nextRow, 11).Value = "UNPAID"
        
    End If

Next i

MsgBox "Payroll Generated Successfully!", vbInformation

End Sub



Private Sub cmdClose_Click()
    Unload Me
End Sub




Private Sub UserForm_Initialize()

cboPaymentMethod.Clear
cboPaymentMethod.AddItem "Cash"
cboPaymentMethod.AddItem "Bank Transfer"
cboPaymentMethod.AddItem "Mobile Money"
cboPaymentMethod.AddItem "Cheque"

txtPaymentDate.Value = Date

End Sub


Private Sub cmdMarkPaid_Click()

Const PAY_SHEET = "PAYROLL"
Dim ws As Worksheet
Dim lastRow As Long
Dim r As Long
Dim payMonth As Date
Dim rowMonth As Date
Dim found As Boolean
Dim cellVal As Variant

If txtMonth.Value = "" Then
    MsgBox "Please enter payroll month first", vbExclamation
    Exit Sub
End If

If cboPaymentMethod.Value = "" Then
    MsgBox "Select payment method", vbExclamation
    Exit Sub
End If

'-------------------------------
' Validate Entered Month
'-------------------------------
On Error Resume Next
payMonth = CDate(txtMonth.Value)
If Err.Number <> 0 Then
    MsgBox "Invalid month format. Example: Jan-2025", vbCritical
    Exit Sub
End If
On Error GoTo 0

Set ws = Sheets(PAY_SHEET)
lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
found = False

'-------------------------------
' LOOP PAYROLL ROWS
'-------------------------------
For r = 2 To lastRow
    
    If ws.Cells(r, 2).Value <> "" Then
        
        rowMonth = 0
        cellVal = ws.Cells(r, 2).Value
        
        ' If value is already a date (your case)
        If IsDate(cellVal) Then
            rowMonth = CDate(cellVal)
        Else
            ' Try converting text month like Jan-25
            On Error Resume Next
            rowMonth = DateValue("1 " & CStr(cellVal))
            On Error GoTo 0
        End If
        
        ' If we successfully interpreted date
        If rowMonth <> 0 Then
        
            If Month(rowMonth) = Month(payMonth) And _
               Year(rowMonth) = Year(payMonth) Then
               
                ws.Cells(r, 11).Value = "PAID"
                ws.Cells(r, 12).Value = txtPaymentDate.Value
                ws.Cells(r, 13).Value = cboPaymentMethod.Value
                ws.Cells(r, 14).Value = txtNotes.Value
                
                found = True
            
            End If
        
        End If
    
    End If
    
Next r

If found Then
    MsgBox "Payroll Marked as PAID Successfully!", vbInformation
Else
    MsgBox "No payroll records found for selected month", vbExclamation
End If

End Sub




